/*
 * Created on Aug 1, 2003
 */

package Interface;

import Data.*;
import DatabaseCommunication.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

/**
 * @author student

 * This class is being used for display availability of different users
 * 
 */
public class TabAvailability extends JPanel implements ActionListener {

	static JComboBox comboBoxN;
	static JTable tableAvailability;
	static DefaultComboBoxModel comboBoxModel;
	static DefaultListModel listModel;
	static JPanel avPanel;
	static JLabel message = new JLabel();
	static DefaultTableModel myData;

	/**
	 * This is the constructor for TabAvailability.java
	 */
	public TabAvailability() {
		super();
	}

	/**
	 * This method is being used to create availability Tab
	 * @return JPanel
	 */
	public JPanel createTabAvailability() {

		myData = new DefaultTableModel();

		myData.addColumn("Names");
		myData.addColumn("In/Out");

		//get all the users
		fillNames();
		tableAvailability = new JTable(myData);
		tableAvailability.setFont(new Font("Times New Roman", Font.BOLD, 12));

		tableAvailability.setModel(myData);

		JScrollPane tableScrollPane = new JScrollPane(tableAvailability);
		tableAvailability.setPreferredScrollableViewportSize(
			new Dimension(500, 150));
		tableScrollPane.setHorizontalScrollBarPolicy(
			JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);

		avPanel = new JPanel();
		avPanel.add(new JLabel("Check for the Availability"));
		//avPanel.setLayout(new BoxLayout(avPanel,BoxLayout.Y_AXIS));
		tableAvailability.setPreferredSize(new Dimension(500, 150));
		avPanel.add(tableAvailability);
		comboBoxModel = new DefaultComboBoxModel();
		comboBoxN = new JComboBox(comboBoxModel);
		comboBoxN.addActionListener(this);
		comboBoxN.setModel(comboBoxModel);
		comboBoxN.setPreferredSize(new Dimension(150, 20));
		avPanel.add(comboBoxN);

		return avPanel;
	}
	public void actionPerformed(ActionEvent e) {
		JComboBox cb = (JComboBox) e.getSource();
		String name = (String) cb.getSelectedItem();
		System.out.println(name);
		display(name);
	}
	/**
	 * This method is being used to fill names in the display table
	 *  void
	 */
	public static void fillNames() {

		UserManager uManager = new UserManager();
		UserData[] userArray = new UserData[10];
		try {
			userArray = uManager.selectAllUsers();
			for (int i = 0; i < userArray.length; i++) {

				Object[] row =
					{
						userArray[i].getFName() + " " + userArray[i].getLName(),
						userArray[i].getInOut()};
				comboBoxModel.addElement(
					userArray[i].getFName() + " " + userArray[i].getLName());
				myData.addRow(row);
				tableAvailability.setModel(myData);
				comboBoxN.setModel(comboBoxModel);

			}
			message.setText("rows have been added");
		} catch (Exception exp) {
			//					message.setText("Error while inserting user data "+exp.toString());
		}
	}

	/**
	 * This method is being used to refresh the display table
	 *  void
	 */
	public void refresh() {
		myData = new DefaultTableModel();
		comboBoxModel = new DefaultComboBoxModel();

		myData.addColumn("Names");
		myData.addColumn("In/Out");
		fillNames();
	}
	/**
	 * This method is being used to display whether user is In or Out
	 * @param name void
	 */
	public void display(String name) {
		for (int i = 0; i <= tableAvailability.getRowCount() - 1; i++) {
			System.out.println(name);
			if (tableAvailability.getValueAt(i, 0).equals(name))
				tableAvailability.setRowSelectionInterval(i, i);
		}

	}

}
